/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.FriendsListScreen;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.polylib.gui.SimpleSelectionList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MutedUsersScreen
extends Screen {
    private static final String CROSS = Character.toString(10006);
    private static final Logger LOGGER = LogManager.getLogger();
    private final Screen previous;
    private SimpleSelectionList<MutedEntry> list;
    private EditBox searchBox;

    public MutedUsersScreen(Screen previous) {
        super((Component)new TranslatableComponent("minetogether:screen.muted.title"));
        this.previous = previous;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.list == null) {
            this.list = new SimpleSelectionList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64, 36);
        } else {
            this.list.m_93437_(this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64);
        }
        this.m_142416_((GuiEventListener)this.list);
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, this.f_96544_ - 32, 160, 20, TextComponent.f_131282_);
        this.searchBox.m_94167_("Search");
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)new Button(5, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("minetogether:button.cancel"), e -> this.f_96541_.m_91152_(this.previous)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 105, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("minetogether:button.refresh"), e -> this.refreshList()));
        if (!(this.previous instanceof FriendsListScreen)) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 105, 5, 100, 20, (Component)new TranslatableComponent("minetogether:button.friends"), e -> this.f_96541_.m_91152_((Screen)new FriendsListScreen(this))));
        }
        this.refreshList();
    }

    public void refreshList() {
        this.list.m_93516_();
        String searchTerm = this.searchBox.m_94155_();
        for (Profile mutedProfile : MineTogetherChat.CHAT_STATE.profileManager.getMutedProfiles()) {
            if (!StringUtils.isEmpty((CharSequence)searchTerm) && !StringUtils.containsAnyIgnoreCase((CharSequence)mutedProfile.getDisplayName(), (CharSequence[])new CharSequence[]{searchTerm})) continue;
            this.list.m_7085_(new MutedEntry(this.list, mutedProfile));
        }
    }

    public boolean m_5534_(char c, int i) {
        boolean ret = super.m_5534_(c, i);
        if (this.searchBox.m_93696_()) {
            this.refreshList();
        }
        return ret;
    }

    public boolean m_7933_(int i, int j, int k) {
        boolean ret = super.m_7933_(i, j, k);
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_94167_(null);
            this.refreshList();
        }
        return ret;
    }

    private class MutedEntry
    extends SimpleSelectionList.SimpleEntry<MutedEntry> {
        private final Profile profile;
        private float transparency;

        public MutedEntry(SimpleSelectionList<MutedEntry> list, Profile profile) {
            super(list);
            this.transparency = 0.5f;
            this.profile = profile;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int idx, int top, int left, int width, int height, int mx, int my, boolean hovered, float partialTicks) {
            Minecraft mc = Minecraft.m_91087_();
            if (hovered) {
                if (this.transparency <= 1.0f) {
                    this.transparency = (float)((double)this.transparency + 0.04);
                }
            } else if (this.transparency >= 0.5f) {
                this.transparency = (float)((double)this.transparency - 0.04);
            }
            mc.f_91062_.m_92883_(poseStack, this.profile.getDisplayName(), (float)(left + 5), (float)(top + 5), 0xFFFFFF);
            RenderSystem.m_69478_();
            mc.f_91062_.m_92883_(poseStack, CROSS, (float)(width + left - mc.f_91062_.m_92895_(CROSS) - 4), (float)top, 0xFF0000 + ((int)(this.transparency * 254.0f) << 24));
            RenderSystem.m_69461_();
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int i) {
            Minecraft mc = Minecraft.m_91087_();
            int listWidth = (this.list.getWidth() - this.list.m_5759_()) / 2 + this.list.m_5759_();
            int yTop = this.list.getRowTop(this);
            if (mouseX >= (double)(listWidth - mc.f_91062_.m_92895_(CROSS) - 4) && mouseX <= (double)(listWidth - 3) && mouseY - (double)yTop >= 0.0 && mouseY - (double)yTop <= 7.0) {
                this.profile.unmute();
                MutedUsersScreen.this.refreshList();
            }
            return super.m_6375_(mouseX, mouseY, i);
        }
    }
}

